/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections.longs;

/**
 * Iterator over a list of long numbers.
 * @see java.util.ListIterator
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface LongListIterator extends LongIterator {
    boolean hasNext();
    long next();
    boolean hasPrevious();
    long previous();
    int nextIndex();
    int previousIndex();
    void remove();
    void set(long e);
    void add(long e);
}
